
#if ARDUINO > 18
#include <SPI.h> // Für Arduino Version größer als 0018
#endif
#include <Ethernet.h>
#include <TextFinder.h>
#include <SD.h>

boolean grillAn = false;
boolean statusrequest = true;          //Unterscheidung, ob Daten abgerufen werden oder die HTML Seite


char actionString[16];
const int fileStringLength = 24;       // Länge der Datenabfrage
const int typeLength = 6; 
char requestTypeString[typeLength]; 
char fileString[fileStringLength];

byte mac[] = { 
  0x90, 0xA2, 0xDA, 0x0D, 0x57, 0x90 }; // MAC-Adresse des Ethernet-Shields
byte ip[]  = { 
  192, 168, 0, 88 };                   // IP zum aufrufen des Webservers
byte sdPin = 4;                                      // Pin der SD-Karte

EthernetServer server(80);                           // Server port

File webFile;

void setup()
{ 
  Ethernet.begin(mac, ip);             // Client starten
  server.begin();                      // Server starten
  Serial.begin(9600);
  Serial.println("ARDUINO - STEUERUNG");

  Serial.println("Initialisiere SD-Karte...");
  if (!SD.begin(sdPin))
  {
    Serial.println(" - Initialisierung der SD-Karte fehlgeschlagen!");
    return;
  }
  Serial.println(" - SD-Karte erfolgreich initialisiert.");

  if (!SD.exists("index.htm"))
  {
    Serial.println(" - Datei (index.htm) wurde nicht gefunden!");
    return;
  }
  Serial.println(" - Datei (index.htm) wurde gefunden.");

  Serial.println();
  Serial.println("Verbraucher schalten");
}

void loop()
{
  EthernetClient client = server.available();             // Auf Anfrage warten
  int requestType = 0;                                    // Welche Art der Nachfrage (GET or POST);
  int requestedFileLength = 0;
  
  if(client)
  {

    /*****************************************
     * Ausgänge über das Webformular steuern  *
     *****************************************/
    TextFinder finder(client);

    if(finder.getString("","/", requestTypeString,typeLength)){
      // Unterscheidung GET or POST:
      if(String(requestTypeString) == "GET " ) {
        requestType = 1;
      }
      else if(String(requestTypeString) == "POST ") {
        requestType = 2;
      }

      // gather what comes after the / into an array,
      // it's the filename the client wants:
      requestedFileLength = finder.getString("", " ", 
      fileString, fileStringLength);

      switch (requestType) {
      case 1:                          // GET, Daten/Seite abrufen
        if (requestedFileLength < 2) 
        {
          statusrequest = false;
          Serial.println("HTML Steuerungsseite ausgeben");
        }else{
          statusrequest = true;
          Serial.println("Status ausgeben");
        }  
        break;
      case 2:                            //POST, Schaltvorgang durchführen
                                         //Hier wird nur nach der länge des Anfragestrings unterschieden, da ein Suchen in der Anfrage nicht gut funktioniert
        Serial.println(requestedFileLength);
        switch (requestedFileLength){
          case 22:  // /?action=switchgrillon = 22 Zeichen
          
            //TODO: Hier Code zum Anschalten bei Implementierung in Grillprogramm
            //Aufruf als POST
            
            grillAn = true;
            Serial.println("Grill anschalten");
            break;
          case 23:  // /?action=switchgrilloff = 21 Zeichen
          
            //TODO: Der Code zum Abschalten bei Implementierung in Grillprogramm
            //Aufruf als POST
            
            grillAn = false;
            Serial.println("Grill ausschalten");
            break;
        }
        
        break; 
      }
    }





    /************************
     * Webformular anzeigen  *
     ************************/
    boolean current_line_is_blank = true;       // eine HTTP-Anfrage endet mit einer Leerzeile und einer neuen Zeile

      while (client.connected())
    {
      if (client.available())                   // Wenn Daten vom Server empfangen werden
      {
        char c = client.read();                 // empfangene Zeichen einlesen
        if (c == '\n' && current_line_is_blank) // wenn neue Zeile und Leerzeile empfangen
        { // Standard HTTP Header senden
          
          switch (requestType) {
          case 1: //GET, entweder Status oder Datei ausgeben
            if(statusrequest){
              client.println("HTTP/1.1 200 OK");
              client.println("Content-Type: application/json");
              client.println("Access-Control-Allow-Origin: *");
              client.println("Connection: close");
              client.println();
              client.print("{\"temperature\" : \"");
              
              //TODO: Hier die Temperatur ausgeben
              
              client.print(random(10,4000));
              client.print("\", \"grillstatus\": \"");
              
              //TODO: Hier den Grillstatus ausgeben
              
              
              client.print(grillAn ? "an" : "aus");
              client.println("\"}");
            }else{
                                                    // Website von SD-Karte laden
              client.println("HTTP/1.1 200 OK");
              client.println("Content-Type: text/html");
              client.println("Access-Control-Allow-Origin: *");
              client.println("Connection: close");
              client.println();
  
              webFile = SD.open("index.htm");         // Website laden
              if (webFile)
              {
                while(webFile.available())
                {
                  client.write(webFile.read());        // Website an Client schicken
                }
                webFile.close();
              }
            }
            break;
          case 2: //POST, wir kennen keine Fehlerfälle beim umschalten, geben immer OK zurück ;)
            client.println("HTTP/1.1 200 OK");
            client.println("Content-Type: application/json");
            client.println("Access-Control-Allow-Origin: *");
            client.println("Connection: close");
            client.println();
            client.print("{\"result\" : \"OK\"}");
            break;
          }
          break;
        }
        if (c == '\n')
        {
          current_line_is_blank = true;
        }
        else if (c != '\r')
        {
          current_line_is_blank = false;
        }
      }
    }
    delay(1);
    client.stop();
  }
}

